/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.integrator;

import filenet.vw.apps.taskman.VWTaskPropertyChangedEvent;
import filenet.vw.apps.taskman.VWTaskTabPanel;
import filenet.vw.apps.taskman.integrator.VWManagerNode;
import filenet.vw.apps.taskman.integrator.VWManagerUtil;
import filenet.vw.apps.taskman.integrator.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.ws.listener.utils.WSListenerProperties;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class VWWSJSSEPanel
extends VWTaskTabPanel
implements ActionListener {
    VWManagerNode m_node = null;
    VWManagerUtil m_util = new VWManagerUtil(0);
    JTextField m_keystoreFile = null;
    JPasswordField m_keystorePassword = null;
    JPasswordField m_truststorePassword = null;
    JCheckBox autoAcceptCertificatesChk = null;
    JTextField m_truststoreFile = null;
    JButton m_browseKeyStore = new JButton(VWResource.Browse);
    JButton m_browseTrustStore = new JButton(VWResource.Browse);
    protected FileDialog m_fileDialog = null;

    public VWWSJSSEPanel(VWManagerNode node) {
        this.m_node = node;
        this.initLayout();
        this.m_fileDialog = new FileDialog((Frame)node.getTaskCore().getMainFrame(), VWResource.SelectFile, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyProperties() {
        try {
            WSListenerProperties props = this.m_node.getWSListenerProperties();
            if (props == null) {
                return;
            }
            WSListenerProperties wSListenerProperties = props;
            synchronized (wSListenerProperties) {
                props.setJSSEOptions(this.m_keystoreFile.getText(), this.m_util.getEString("keystore", new String(this.m_keystorePassword.getPassword())), this.m_truststoreFile.getText(), this.m_util.getEString("keystore", new String(this.m_truststorePassword.getPassword())), this.autoAcceptCertificatesChk.isSelected());
            }
            this.m_keystoreFile.setText(props.getKeystoreFile());
            this.m_truststoreFile.setText(props.getTruststoreFile());
            props = null;
        }
        catch (Exception e) {
            VWDebug.logException(e, "Exception while applying properties to WSListenerProperties.");
        }
    }

    protected void resetProperties() {
        try {
            WSListenerProperties props = this.m_node.getWSListenerProperties();
            if (props == null) {
                return;
            }
            this.m_keystoreFile.setText(props.getKeystoreFile());
            this.m_truststoreFile.setText(props.getTruststoreFile());
            this.m_keystorePassword.setText(props.getKeystorePassword());
            this.m_truststorePassword.setText(props.getTruststorePassword());
            boolean checked = props.getCertificatesAutoAccept();
            this.autoAcceptCertificatesChk.setSelected(checked);
        }
        catch (Exception e) {
            VWDebug.logException(e, "Exception while re-getting properties from WSListenerProperties.");
        }
    }

    protected void updateState(boolean enabled) {
        this.m_keystoreFile.setEditable(enabled);
        this.m_keystorePassword.setEditable(enabled);
        this.m_keystorePassword.setEditable(enabled);
        this.m_truststorePassword.setEditable(enabled);
        this.m_truststoreFile.setEditable(enabled);
        this.autoAcceptCertificatesChk.setEnabled(enabled);
    }

    public void actionPerformed(ActionEvent e) {
        String title = null;
        String selectedFile = null;
        boolean forKeyStore = false;
        boolean bl = forKeyStore = e.getSource() == this.m_browseKeyStore;
        if (forKeyStore) {
            title = VWResource.SelectFileForKeystore;
            selectedFile = this.m_keystoreFile.getText();
        } else {
            title = VWResource.SelectFileForTruststore;
            selectedFile = this.m_truststoreFile.getText();
        }
        if (selectedFile == null || selectedFile.trim().length() == 0) {
            selectedFile = System.getProperty("java.home") + "/lib/security/cacerts";
        }
        try {
            File aFile = new File(selectedFile);
            this.m_fileDialog.setDirectory(aFile.getParent());
            this.m_fileDialog.setFile(aFile.getName());
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.m_fileDialog.setTitle(title);
        this.m_fileDialog.setVisible(true);
        String name = this.m_fileDialog.getFile();
        if (name != null) {
            selectedFile = this.m_fileDialog.getDirectory() + this.m_fileDialog.getFile();
            if (forKeyStore) {
                this.m_keystoreFile.setText(selectedFile);
            } else {
                this.m_truststoreFile.setText(selectedFile);
            }
        }
        this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, null));
    }

    private void initLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 10, 5, 5);
        c.gridwidth = 1;
        c.anchor = 23;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.fill = 0;
        this.m_keystoreFile = new JTextField("");
        this.m_keystoreFile.setName(VWResource.KeystoreFile);
        this.m_keystoreFile.addFocusListener(this);
        this.add((Component)new JLabel(this.m_keystoreFile.getName() + ":"), c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.add((JTextComponent)this.m_keystoreFile, (Object)c, false);
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        this.m_browseKeyStore.addActionListener(this);
        this.add((Component)this.m_browseKeyStore, c);
        c.gridx = 0;
        ++c.gridy;
        this.m_keystorePassword = new JPasswordField("");
        this.m_keystorePassword.setName(VWResource.KeystorePassword);
        this.m_keystorePassword.addFocusListener(this);
        this.add((Component)new JLabel(this.m_keystorePassword.getName() + ":"), c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.add((JTextComponent)this.m_keystorePassword, (Object)c, false);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        c.weightx = 0.0;
        this.m_truststoreFile = new JTextField("");
        this.m_truststoreFile.setName(VWResource.TruststoreFile);
        this.m_truststoreFile.addFocusListener(this);
        this.add((Component)new JLabel(this.m_truststoreFile.getName() + ":"), c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.add((JTextComponent)this.m_truststoreFile, (Object)c, false);
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        this.m_browseTrustStore.addActionListener(this);
        this.add((Component)this.m_browseTrustStore, c);
        c.gridx = 0;
        ++c.gridy;
        this.m_truststorePassword = new JPasswordField("");
        this.m_truststorePassword.setName(VWResource.TruststorePassword);
        this.m_truststorePassword.addFocusListener(this);
        this.add((Component)new JLabel(this.m_truststorePassword.getName() + ":"), c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.add((JTextComponent)this.m_truststorePassword, (Object)c, false);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        this.autoAcceptCertificatesChk = new JCheckBox(VWResource.AutoAcceptCertificates);
        this.add((Component)this.autoAcceptCertificatesChk, c);
        this.resetProperties();
    }

    public String getHelpPage() {
        return VWHelp.Help_Process_TaskManager + "cm_config_ws.htm";
    }
}

